# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Thread/Queue/Duplex.pm) perl(Thread/Queue/Queueable.pm) perl(base.pm) perl(threads.pm) perl(threads/shared.pm) perl(use.pm)
# END SourceDeps(oneline)
%define module_version 0.92
%define module_name Thread-Queue-Multiplex
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.92
Release: alt1
Summary: thread-safe publish/subscribe queue
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DARNOLD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A subclass of the Thread::Queue::Duplex manpage *aka* TQD which implements a
"publish and subscribe" communications model for threads. Subscribers
register with the queue, which registers either the provided subscriber ID,
or, if no ID is provided, 1 plus the TID of the subscriber's thread,
as a subscriber ID. As the publisher publishes
messages to the queue, each subscriber receives
a copy of the message. If the publication is not simplex, the publisher
expects all subscribers to read and respond to the message; otherwise, the
publisher simply continues its processing. Thread::Queue::Multiplex
provides `publish()' method counterparts for all the the Thread::Queue::Duplex manpage
`enqueue()' methods, e.g., `publish_simplex(), publish_urgent(),
publish_and_wait(), publish_and_wait_until()', etc.

Subscribers receive and reply to messages using the existing TQD
dequeue() and respond() methods. In addition, modified versions of
the enqueue() methods are provided to publishers to permit directing
a message to a single subscriber, or subset of subscribers, by specifying
the scalar subscriber ID (for single subscriber messages), or
an arrayref of unique subscriber ID's (for multi-subscriber messages).

`Thread::Queue::Multiplex' subclass overrides some of the internal behavior
of the Thread::Queue::Duplex manpage by

=over 4

=item *

adding a shared hash to hold the list of unique subscriber ID's
(provided either explicitly with `subscribe()', or derived from
1 + the threads manpage`->self()->tid()' when the
subscriber `subscribe()'s) mapped to a threads::shared
array to hold ID's of messages published to the subscriber.
(Note: tid() + 1 is used in order to avoid an ID of zero
for the root thread).

=item *

adding a shared hash to hold the list of message ID's
mapped to a threads::shared array to containing
`[message ID, flags, refcount, @params]', where
`flags' indicates the urgent and/or simplex status
of the request, and `refcount' indicates the number
of subscribers assigned to the request. A special `refcount'
value of -1 indicates that only the first subscriber to
retrieve/process the request should respond (to mimic the
behavior of the Thread::Queueu::Duplex manpage), which is
specified by the publisher using any of the `enqueue'
methods with a subscriber ID of -1.

=item *

adding a shared hash to hold the list of message ID's
mapped to a the threads::shared manpage hash containing
a reference count of subscribers for the message,
and a map of subscriber IDs to their responses.
This "pending response" hash is used to accumulate
all subscriber responses; when the reference count of
a message is zero, the hash of responses is posted to
the final response message mapping hash.

=item *

adding a shared hash to hold the map of thread ID's to
subscriber ID's. Note: Each thread can have only a single
subscriber.

=item *

changing the message mapping hash to map a unique message ID
to a hash of unique subscriber ID's, mapped to their response (if any),
i.e.,

	$msg_map = {
		$msgid => {
			$subID1 => $subID1_response,
			$subID2 => $subID2_response,
			etc.
		}
	}

=item *

when the publisher dequeues the response to a message, it receives
a copy of the subscriber mapping hash, and is responsible for iterating
over the hash to read each subscriber's results

=back

A normal processing sequence for Thread::Queue::Multiplex might be:

	#
	#	Thread A (the client):
	#
		...marshal parameters for a coroutine...
		my $id = $tqm->publish('function_name', \@paramlist);
		my $results = $tqm->dequeue_response($id);
		while (($subID, $subresult) = each %%$results) {
		...process $results...
		}
	#
	#	Thread B (a subscriber):
	#
		while (1) {
			my $call = $tqm->dequeue;
			my ($id, $func, @params) = @$call;
			$tqm->respond($id, $self->$func(@params));
		}


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc License.txt Changes.txt
%perl_vendor_privlib/T*

%changelog
