# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(IO/Scalar.pm) perl(IPC/System/Simple.pm) perl(JSON.pm) perl(Module/CoreList.pm) perl(Term/ANSIColor.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define module_name ThreatDetector
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Modular Apache Log Threat Detection for Vicidial
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHALL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
ThreatDetector is a modular, extensible, Perl-based threat detection framework for parsing Apache logs. It detects web attacks such as SQL Injection, XSS, Command Injection, Directory Traversal, and more. Designed with call center infrastructures and Vicidial clusters in mind, it supports multi-host scanning via SSH and generates rich summary reports.

---


- Detects and classifies:
  - SQL Injection
  - Cross-Site Scripting (XSS)
  - Command Injection
  - Login Brute-Force
  - Directory Traversal
  - Encoded Payloads
  - HTTP Method Abuse
  - Suspicious Headers
  - Bot Fingerprints
  - 400.e'499 Client Errors
- Smart, pluggable classifier
- Per-host threat summary report
- Multi-host support via SSH (partial WIP under `utils`)
- Optional verbose colorized CLI output
- Designed to work with Vicidial environments out-of-the-box

---


- Perl 5.10 or later
- These CPAN modules:

```bash
cpan install JSON File::Slurp Getopt::Long Term::ANSIColor IPC::System::Simple
```

```bash

use strict;
use warnings;
use ThreatDetector;

my $log_file    = '/var/log/apache2/access.log';
my $config_file = '/etc/threatdetector/config.json';  # or wherever you placed it

ThreatDetector::analyze_log($log_file, $config_file);
```


- `bin/`
  - `detect.pl` .e' Main scanner CLI
- `config/`
  - `config.json` .e' Log file path, output dir, verbosity
- `data/`
  - `ip_cache.sqlite` .e' (Optional future use)
- `lib/ThreatDetector/` .e' Classifier, dispatcher, handlers, reporter
- `logs/`
  - `YYYY-MM-DD_threat_results.log` .e' Output reports
- `t/`
  - `*.t` .e' Unit tests
- `utils/`
  - `add_shebang.pl` .e' Add missing shebangs
  - `check_deps.pl` .e' Verify/install required modules
  - `find_used_modules.pl` .e' Extract used modules for PREREQ_PM
  - `ssh_remote_runner.pl` .e' Remote SSH scanner (NOT COMPLETE)
- `Makefile.PL` .e' CPAN build script
- `MANIFEST` .e' Package contents
- `README.md` .e' This file


```bash
perl bin/detect.pl --logfile /var/log/apache2/access.log
```


```bash
prove -lv t/
```

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md
%perl_vendor_privlib/T*

%files scripts
%_bindir/*

%changelog
