%define module_version 0.007
%define module_name Throwable-Factory
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/Struct.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Throwable/Error.pm) perl(Try/Tiny.pm) perl(Try/Tiny/ByClass.pm) perl(base.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: lightweight Moo-based exception class factory
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Throwable-Factory

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Throwable::Factory' is an the Exception::Class manpage-like exception factory
using the MooX::Struct manpage.

All exception classes built using `Throwable::Factory' are the MooX::Struct manpage
structs, but will automatically include a `message' attribute, will compose
the the Throwable manpage and the StackTrace::Auto manpage roles, and contain the following
convenience methods:

=over

=item `error'

Read-only alias for the `message' attribute/field.

=item `package'

Get the package for the first frame on the stack trace.

=item `file'

Get the file name for the first frame on the stack trace.

=item `line'

Get the line number for the first frame on the stack trace.

=back

They provide a `BUILDARGS' method which means that if their constructor
is called with an odd number of arguments, the first is taken to be the
message, and the rest named parameters.

Additionally, the factory can be called with Exception::Class-like hashrefs
to describe the exception classes. The following two definitions are
equivalent:

   # MooX::Struct-style
   use Throwable::Factory FooBar => [
      -extends => ['Foo'],
      qw( foo bar ),
   ];
   
   # Exception::Class-style
   use Throwable::Factory FooBar => {
      isa    => 'Foo',
      fields => [qw( foo bar )],
   };


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README COPYRIGHT Changes
%perl_vendor_privlib/T*

%changelog
