# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Tie/IxHash.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Tie-Autotie
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Automatically ties underlying references
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PI/PINYAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module allows you to automatically tie data structures contained in
a tied data structure.  As an example:

  use Tie::Autotie 'Tie::IxHash';

  tie my(%%hash), 'Tie::IxHash';

  $hash{jeff}{age} = 22;
  $hash{jeff}{lang} = 'Perl';
  $hash{jeff}{brothers} = 3;
  $hash{jeff}{sisters} = 4;

  $hash{kristin}{age} = 22;
  $hash{kristin}{lang} = 'Latin';
  $hash{kristin}{brothers} = 1;
  $hash{kristin}{sisters} = 0;

  for my $who (keys %%hash) {
    print "$who:\n";
    for my $what (keys %%{ $hash{$who} }) {
      print "  $what = $hash{$who}{$what}\n";
    }
  }

This program outputs:

  jeff:
    age = 22
    lang = Perl
    brothers = 3
    sisters = 4
  kristin:
    age = 22
    lang = Latin
    brothers = 1
    sisters = 0

You can see that the keys of %%hash are returned in the order in which they
were created, *as well* as the keys of the sub-hashes.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
