%define module_name Tie-CSV_File
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Compare.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Params/Validate.pm) perl(Test/Exception.pm) perl(Test/ManyParams.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Text/CSV_XS.pm) perl(Tie/File.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.25
Release: alt1
Summary: ties a csv-file to an array of arrays
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BIGJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Tie::CSV_File' represents a regular csv file as a Perl array of arrays.  
The first dimension of the represents the line-nr in the original file,
the second dimension represents the col-nr.
Both indices are starting with 0.
You can also access with the normal array value,
e.g. `$data[-1][-1]' stands for the last field in the last line,
or `@{$data[1]}' stands for the columns of the second line.

An empty field has the value `''', 
while a not existing field has the value `undef'.
E.g. about the file

  "first field",,
  "last field"
  
  "the above line is empty"
  
we can say

  $data[0][0] eq "first field"
  $data[0][1] eq ""
  !defined $data[0][2] 
  
  $data[1][0] eq "last field"
  
  @{$data[2]}  # is an empty list ()
  !defined $data[2][0]

  $data[3][0] eq "the above line is empty"

  !defined $data[$x][$y] # for every $x > 3, $y any 

Similar every row from `0 .. $#data' exists. (Even if some of them have never
been set explicitly). The same principle works also for the columns (every
between the first and the last defined one exists for each row). So, belonging
to this module, the `defined' method and the `exists' operator are equivalent.

Note, that it is possible also, to change the data.

  $data[0][0]   = "first line, first column";
  $data[3][7]   = "anywhere in the world";
  $data[-1][-1] = "last line, last column";
  
  $data[0] = ["Last name", "First name", "Address"];
  push @data, ["Schleicher", "Janek", "Germany"];
  my @header   = @{ shift @data };
  my @last_row = @{ pop   @data };

You can also assign the content of whole another array to the csv-tied array.
It has the effect that the content of the other array is copied and it
overwrites the previous content. However, it's perhaps the easiest way to
create a csv file :-)
  
Please pay attention that deleting an array element has a slightly
different meaning to the normal behaviour.
Deleting an element set the element empty ("" or []),
but not undef.

  delete $data[5];    # similar to $data[5] = [];
  delete $data[5][5]; # similar to $data[5][5] = "";

In fact, in a file there is no value undefined.
A cell of the CSV-File can only be empty ("").
Undefined values signalizes that the line or the column doesn't exist.
Especially the lines `,,,' and `"","","",""' are the same for
`Tie::CSV_File' and the second version could be changed
without a warning to the first one (and vice versa if the autoquote option is
set) when you write to the tied array.
  
There's only a small part of the whole file in memory,
so this module will work also for large files.
Please look the the Tie::File manpage module for any details,
as I use it to read the lines of the file.

But it won't work with large fields,
as all fields of one line are parsed,
even if you only want to get one field.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
