# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Tie-DBIx-Class
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Tie a DBIx::Class ResultSet into a hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SE/SEWI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module ties a DBIx::Class::ResultSet into a simple hash but loads
the referenced DBIx::Class::ResultSet only on request reducing database
access.

DBIx::Class puts a SQL row into a simple object and masks all SQL from
you scripts, but it's strictly database based.

Imagine you got a house:

my $house = House->new(1);
$house->open_door();

$house could be a SQL row, but what if you'ld like
to add methods or sub-objects which aren't SQL rows?

Here is what Tie-DBIx-Class is for:

package House;

sub new {
    my $class = shift;
    my $house_id = shift;
    tie(my %%row,'Tie::DBIx::Class',$main::schema,'houses',$house_id);
    return bless \%%row,$class;
}

sub open_door {
    # Access the door controller
}

Every column is accessible as a hash key of the blessed object
while you're still free to define additional methods.

In addition, Tie::DBIx::Class waits for the first access to
the hash's data before actually fetching the data from the
database - saving resources in case you just want to open the
door and don't need the SQL row's data at all.

Tie::DBIx::Class has been developed for use with
Template::Toolkit. Templates may get access to database rows
without the need to preload everything which might be used by
a template. Just create the objects and push them to
Template::Toolkit and the required rows will be loaded
automatically.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
