%define module_name Tie-Hash-Attribute
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: Print hash values as rotating HTML attributes.
Group: Development/Perl
License: artistic_2
URL: https://github.com/jeffa/Tie-Hash-Attribute

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JEFFA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module will translate the keys and values into HTML tag attributes.
You just need to provide the tags.

Hash values can be scalars, arrays, hashes or hashes of hashes.

To emit values as an HTML attribute string, fetch the key with
a dash prepended to it:

  %%hash = ( foo => 1, bar => 2, baz => 3);

  print $hash{foo};     # returns original value
  print $hash{-foo};    # returns value as HTML attribute string

Or access the entire hash as a scalar:

  print scalar %%hash;

You can use this to to aide in the creation of HTML tags:

  print '<table>';
  for my $row (@rows) {
      printf '<tr%%s>', scalar %%tr;
      for my $col (@$row) {
          printf '<td%%s>%%s</td>', scalar %%td, $col;
      }
      print '</tr>';
  }

The decision on which style to apply to a row is deferred to
the tied hash.  Just assign an array reference to the key and
each value will be rotated.

  %%tr_tag = ( class => [qw( odd even )] );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes readme.md
%perl_vendor_privlib/T*

%changelog
