# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.9
%define module_name Tie-Hash-Layered
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: Perl extension for layerable hash values
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SI/SIMONW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module lets you layer hashes on top of each other.opaquely so that top most layers obscure bottom ones.

Think of it like sheets of OHP transparencies, if a 
value is set in a top and bottom layer then that's 
you when you access that key you get the value from
the top layer but if you access something not set in
the top layer but set in the bottom layer then you
get the value from the bottom layer ...

... and breathe.

In short :

Tied Hash :   foo=>'bob'  , quux=>'fleeg'
                 |              |     
                 ^              |
Layer 1   :   foo=>'bob'        ^
Layer 2   :   foo=>'bar'  , quux=>'fleeg'



So why is this useful? Well, the obvious application
is for preferences. In a CGI app you could tie in the 
bottom most hash to a database with default all-users' 
preferences, the second layer with the current user's 
preferences, the layer above that with the per-session 
preferences and the layer above that with the 
per-request values.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*
%changelog
