# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Data/Dumper/Sorted.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.08
%define module_name Tie-Hash-MultiKey
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: multiple keys per value
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Tie::Hash::MultiKey creates hashes that can have multiple ordered keys for a single value. 
As shown in the SYNOPSIS, multiple keys share a common value.

Additional keys can be added that share the same value and keys can be removed without deleting other 
keys that share that value.

STORE..ing a value for one or more keys that already exist will overwrite
the existing value and add any missing keys to the key group for that
value.

WARNING: multiple key values supplied as an ARRAY to STORE and DELETE
operations are passed by Perl as a single string separated by Perl's $;
multidimensional array seperator. i.e.

_$hash{'a','b','c'} = $something;
  or
_@keys = ('a','b','c');
_$hash{@keys} = $something'

This really means $hash{join($;, 'a','b','c')};

Tie::Hash::MultiKey will do the right thing as long as your keys DO NOT
contain binary data the may include the $; separator character.

It is recommended that you use the ARRAY_REF construct to supply multiple
keys for binary data. i.e.

_$hash{['a','b','c']} = $something;
  or
_$keys = ['a','b','c'];
_$hash{$keys} = $something;

The ARRAY_REF construct is ALWAYS safe.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
