# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Data/Dumper/Sorted.pm) perl(ExtUtils/MakeMaker.pm) perl(Tie/Hash/MultiKey.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Tie-Hash-MultiKeyCache
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: aged cache or fifo
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a setable fixed size CACHE implemented as a hash with
multiple keys per value. In normal use as new values are added to the CACHE
and the CACHE size is exceeded, the least used items will drop from the
CACHE. Particular items may be locked into the CACHE so they never expire.

The CACHE may also be configured as a FIFO where the first items added to
the CACHE are the first to drop out when size is exceeded. As in the recent 
use scenario, items LOCKED into CACHE will not be dropped.

=over 4

=item * $thm = tie %%h, 'Tie::Hash::MultiKeyCache',

___SIZE_=> n,
___ADDKEY_=> false, # optional
___DELKEY_=> false; # optional
___FIFO_=> true;  # optional
___  over rides ADD,DEL KEY

The arguments beyond the package name may be specified as a hash as shown or
as a reference to a hash.

  $thm = tie %%h $package, { SIZE => n, options... }

Creates a CACHE of maximum SIZE value elements and returns a method
pointer. Default operation refreshes cache positioning for an element
when a ADD Key or DELETE Key operation is performed. To disable this
feature, provide ADDKEY and/or DELKEY with a false value.

  input:_hash,
__cachesize
  returns:_method pointer

The method pointer may also be accessed later with:

_$thm = tied(%%h);


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
