# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper/Interp.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Tie/Hash.pm) perl(feature.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Tie-Indirect
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: tie variables to access data located at run-time.
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JI/JIMAVERA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Each tied variable accesses data located by calling a sub
  which returns a reference to the data.  
 
  The sub is called with parameters ($mutating, optional tie args...)
  where $mutating is true if the access may modify the value. 
 
  tie $scalar, 'Tie::Indirect::Scalar', \&sub, optional tie args...
  tie @array,  'Tie::Indirect::Array',  \&sub, optional tie args...
  tie %%hash,   'Tie::Indirect::Hash',   \&sub, optional tie args...
 
  EXAMPLE:
    my $dataset1 = { foo=>123, table=>{...something...}, list=>[...] };
    my $dataset2 = { foo=>456, table=>{...something else...}, list=>[...] };
 
    my $masterref;
 
    our ($foo, %%table, @list);
    tie $foo,   'Tie::Indirect::Scalar', sub{ \$masterref->{$_[1]} }, 'foo';
    tie %%table, 'Tie::Indirect::Hash',   sub{ $masterref->{$_[1]} }, 'table; 
    tie @list,  'Tie::Indirect::Array',  sub{ $masterref->{list} };
 
    $masterref = $dataset1;
    ... $foo, %%table, and @list now access members of $dataset1
    $masterref = $dataset2;
    ... $foo, %%table, and @list now access members of $dataset2
 

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README
%perl_vendor_privlib/T*

%changelog
