# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Build.pm) perl(Test.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.1
%define module_name Tie-Locked
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: Tie::Locked -- lock hashes so that they cannot be easily changed
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Tie::Locked allows you to create hashes in which the values of the hash cannot
be easily changed.  If an element that does not exist is referenced then the
code croaks.  Tie::Locked is useful for situations where you want to make sure
your code doesn't accidentally change values. If code attempts to change or
delete an existing element, then the code dies. 

I created Tier::Locked when I wrote buggy code something like this:

 my $whatever = {};

 # a bunch of code that, under some conditions, never creates or sets
 # the value $whatever->{'done'}
 
 if (! $whatever->{'done'}) {
    ...
 }

It took an hour of debugging to figure out, so I created this module to avoid
losing more time from things I'd rather do, like write non-buggy code.

Please note: I never actually use Tie::Locked to tie hashes directly.  I use
locked_hashref() and unlocked_hashref() to get hash references.  This
documentation is going to focus on that usage.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
