%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(DB_File.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/File.pm) perl(Storable.pm) perl(Test/More.pm) perl(Tie/DBI.pm)
# END SourceDeps(oneline)
%define module_version 1.04
%define module_name Tie-MLDBM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Multi-Level Storage and Locking Class
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROBAU/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides the means to store arbitrary perl data, including nested 
references, in a serialised form within persistent data back-ends.  This module 
builds upon the storage and locking mechanisms of MLDBM and MLDBM::Sync 
by incorporating a more expandible framework that allows for a much wider 
variety of component modules for serialisation, storage and resource locking.  
Indeed, all storage components of this framework exist as a direct IS-A 
inherited class of their parent storage module such that almost any module 
employing a tied-interface can now store multi-level nested data structures and 
incorporate locking synchronisation.

The Tie::MLDBM framework consists of four components: the interface, the 
locking component, the serialisation component and the storage component.  The 
interface is implemented as a TIEHASH by the Tie::MLDBM module which in turn 
depends upon the functions provided by component modules.  The locking or 
synchronisation component implements shared and exclusive access to the 
underlying storage component by means of semaphores.  The serialisation 
component is that which serialises the nested data structure into a flat form 
ready for storage in the underlying storage component.  The storage component 
can be any new or existing module which implements a TIEHASH interface to a 
persistent store.  All storage modules of this framework inherit directly from 
the storage mechanism which they represent.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
