%define module_version 0.003
%define module_name Tie-Moose
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Traits.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(Types/Standard.pm) perl(Types/TypeTiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: tie a hash to a Moose object (yeah, like Tie::MooseObject)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Tie-Moose

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is much like the Tie::MooseObject manpage. It ties a hash to an instance
of a the Moose manpage-based class, allowing you to access attributes as hash keys. It
uses the accessors provided by Moose, and thus honours read-only attributes,
type constraints and coercions, triggers, etc.

There are a few key differences with the Tie::MooseObject manpage:

=over

=item *

It handles differently named getters/setters more to my liking. Given the
example in the SYNOPSIS, with Tie::MooseObject you need to write:

	$bob{set_age} = 32;
	say $bob{get_age};

Whereas with Tie::Moose, you just use the `age' hash key for both fetching
from and storing to the hash.

=item *

Implements `DELETE' from the the Tie::Hash manpage interface. Tie::MooseObject does
not allow keys to be deleted from its hashes.

(`DELETE' only works on Moose attributes that have a "clearer" method.)

=item *

Supplied with various traits to influence the behaviour of the tied hash.

	tie my %%bob, "Tie::Moose"->with_traits("ReadOnly"), $bob;

(Note that by design, many of the traits supplied with Tie::Moose are
mutually exclusive.)

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT Changes README LICENSE
%perl_vendor_privlib/T*

%changelog
