# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_name Time-Left
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Object model for time limits
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TF/TFBW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple object for managing time limits and a
simple duration string parser function.  It does not generate signals
on its own, but is well-suited to providing values to timers or a
timeout for select().

Objects can be created via time_left() or the new() method.

    $timer = time_left("1m");     # permits unit-qualified strings
    $timer = Time::Left->new(60); # requires number in seconds

The number of seconds remaining is obtained via remaining().

    $sec_left = $timer->remaining;

The $sec_left value becomes negative when the timer has expired.  If
the initial value to new() or time_left() is negative, then the timer
is already expired when created.  There is also an "expired" method
which becomes true at zero or less.

    $bool = $timer->expired;

A timer initialised with undef is an "indefinite" timer.  These always
return undef for the remaining time, which is semantically appropriate
for a select() timeout.  You can test whether a timer object is
limited or indefinite via the is_limited() method.

    $bool = $timer->is_limited;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.md
%perl_vendor_privlib/T*

%changelog
