%define module_name Time-Local-More
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/Local.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: More functions for producing Unix epoch timestamp or localtime/gmtime tuple
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Time-Local-More

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
EARLY RELEASE: API MIGHT CHANGE.

Overview of the module:

=over

=item * The `*startof*' functions

These functions basically "round" the time to the start of minute, hour, day, or
so on. For example, the time_startofday_local entry elsewhere in this document is basically equivalent to:

 my @t = localtime(); # e.g. 1623894635 (Thu Jun 17 08:50:35 2021 Asia/Jakarta)
 $t[0] = 0; # zero the second
 $t[1] = 0; # zero the minute
 $t[2] = 0; # zero the hour
 Time::Local::timelocal_nocheck(@t); # convert back to epoch. result is 1623862800 (Thu Jun 17 00:00:00 2021 Asia/Jakarta)

or alternatively:

 my $t = time();
 my @t = localtime($t);
 $t - $t[0] - $t[1]*60 - $t[2]*3600;

=back

Keywords: start of period, time rounding, truncating timestamp.

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
