# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Role/Tiny.pm) perl(Test/More.pm) perl(Time/Moment.pm) perl(Time/Piece.pm)
# END SourceDeps(oneline)
%define module_name Time-Moment-Role-Strptime
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: strptime constructor for Time::Moment
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Time-Moment-Role-Strptime

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This role composes the the strptime entry elsewhere in this document method, which parses the input string
according to a the strptime(3) manpage format, and constructs a the Time::Moment manpage object.

By default the returned the Time::Moment manpage object is in UTC (possibly adjusted
by a parsed offset); to interpret the parsed time in another time zone, you can
use the Time::Moment::Role::TimeZone manpage:

  use Time::Moment;
  use Role::Tiny ();

  my $class = Role::Tiny->create_class_with_roles('Time::Moment',
    'Time::Moment::Role::Strptime', 'Time::Moment::Role::TimeZone');
  my $moment = $class->strptime($input, $format)->with_system_offset_same_local;

  use DateTime::TimeZone::Olson 'olson_tz';
  my $tz = olson_tz('America/Los_Angeles');
  my $moment = $class->strptime($input, $format)->with_time_zone_offset_same_local($tz);

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md Changes README LICENSE
%perl_vendor_privlib/T*

%changelog
