%define module_name Time-Precise
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0016
Release: alt1
Summary: Extending standard time related functions to always include nanoseconds and always use full year.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZARABOZO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module extends standard functions `time', `localtime', `gmtime' and `sleep' to include nanoseconds as a decimal part of the seconds element.
It also implements and includes functions forked from the Time::Local manpage to work with nanoseconds too, altering its functions
`timelocal' and `timegm'. It also includes a few extra helper functions described bellow.

Note that this module won't affect any other code or modules, it will only affect the standard functions where it is explicitly `use'd.

    use Time::Precise;
    
    # ...or, if you don't want anything exported by default:
    use Time::Precise ();
    
    # ...or, to import only a certain function:
    use Time::Precise qw(time localtime);
    
    # Time in seconds, but includes nanoseconds. (e.g. 1444217081.0396979)
    my $time = time;
    
    # Localtime includes nanoseconds too. (e.g. Wed Oct  7 06:25:44.0032990 2015)
    my $localtime = localtime;
    
    # Same applies here accordingly:
    my @localtime = localtime;
    
    # Sleep for a second and a half:
    sleep 1.5;
    
    # Use functions from Time::Local as normal, but they will work with nanoseconds:
    my $seconds = timelocal @localtime;
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
