# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Time-SoFar
%define upstream_version 1.00

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Perl module to calculate run time
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Time/%{upstream_name}-%{upstream_version}.tgz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
*Time::SoFar* has two functions for calculating how long a script has been
running. 'runtime()' always works from the time the script was started
(using _$^T_). 'runinterval()' works from the last time 'runtime()' or
'runinterval()' was called (or since the start of the script).

Both 'runtime()' and 'runinterval()' use 'figuretimes()' to render a raw
number of seconds into component time units. Both take an optional boolean
argument that gets passed to 'figuretimes()' to influence its output.

In an array context 'figuretimes()' returns the time components as an array,
in a scalar context it returns those components as a *:* delimited string.
The default behaviour is to optimize away 0 output from the longer period
end of the output, leaving a minimum of minutes:seconds. This is good for
arrays that will be passed to 'join()', but not so good for a list of
variables, so this behaviour can be disabled by using a true value for
_$no_optimize_.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README
%perl_vendor_privlib/*




%changelog
