# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Socket.pm) perl(Sys/Hostname.pm) perl(Test.pm) perl(dateheader.pm) perl(Net/DNS.pm)
# END SourceDeps(oneline)
%define module_version 0.34
%define module_name TipJar-MTA
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.34
Release: alt1
Summary: outgoing SMTP with exponential random backoff.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDNICO/SMTP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
On startup, we identify the base directory and make sure we.can write to it, check for and create a few subdirectories,
check if there is an MTA already running and stop if there is,
so that TipJar::MTA can be restarted from cron.

We are not concerned with either listening on port 25 or with
local delivery.  This module implements outgoing SMTP with
exponentially deferred random backoffs on temporary failure.
Future delivery scheduling is determined by what directory
a message appears in.  File age, according to `stat()', is
used to determine repeated deferral.

We reuse a socket to a domain if we had trouble connecting to
the MX for that domain in the past, or for multiple new messages
going to the same domain.  We also cache 4XX and 5XX error codes
on recipients for four hours to eliminate a mess of traffic when,
for instance, we have to bounce many messages to the same
bogus return address.  We will get a "550 User Unknown" error
on the first bounce and throw away the others.

Every `$interval' seconds,  we fork a child process.

A new child process first goes through all new outbound messages
and expands them into individual messages 
and tries to send them.  New messages are to be formatted with the return
address on the first line, then recipient addresses on subsequent lines,
then a blank line (rather, a line with no @ sign), then the body of the message.
The the TipJar::MTA::queue manpage
module will help compose such files if needed.

As of version 0.30, multiple recipients on the first line of a queued file will all be attempted, to the mx of the domain of the host in the first recipient.

Messages are rewritten into multiple messages when they are for
multiple recipients, and then attempted in the order that the
recipients appeared in the file.

After attempting new messages, a child process attempts all messages
in the "immediate" directory.

After attempting all messages in the immediate directory, a child
process moves deferred messages whose times have arrived into the
immediate directory for processing by later children.

Deferred messages are stored in directories named according
to when a message is to be reattempted. Reattempt times are
assigned at requeueing time to be now plus between three and five
quarters of the message age. Messages more than a week old are
not reattempted.  An undeliverable message that got the maximum
deferrment after getting attempted just shy of the one-week deadline
could conceivably be attempted for the final time fifteen and three
quarters days after it was originally enqueued.  Then it would be
deleted.

An array of regular expressions can be specified, and if any of
them match the sender of a bouncing message, the bouncing is
suppressed, so you don't have to waste time with bounce messages from
bad addresses you're sending challenges to for instance.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/T*

%changelog
