Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Tk-ColoredButton
Version:        1.05
Release:        alt3_40
Summary:        Button widget with background gradient color
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Tk-ColoredButton
Source0:        https://cpan.metacpan.org/authors/id/D/DJ/DJIBEL/Tk-ColoredButton-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Tk.pm)
BuildRequires:  perl(Tk/Balloon.pm)
BuildRequires:  perl(Tk/Canvas/GradientColor.pm)
BuildRequires:  perl(Tk/Derived.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(Tk.pm) >= 800
Requires:       perl(Tk/Canvas/GradientColor.pm) >= 1.040

# Filter under-speciefied dependencies

Source44: import.info
%filter_from_requires /^perl(Tk.Canvas.GradientColor.pm)/d

%description
Tk::ColoredButton is an extension of the Tk::Canvas::GradientColor
widget. It is an easy way to simulate a button widget with gradient
background color.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Tk-ColoredButton-%{version}
sed -i -e 's/\r$//' Changes demo/create_buttons.pl README t/00-load.t

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
# Remove tests that do not work out of source tree
rm %{buildroot}%{_libexecdir}/%{name}/t/{boilerplate,pod,pod-coverage}.t
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes demo README
%dir %{perl_vendor_privlib}/Tk
%{perl_vendor_privlib}/Tk/ColoredButton.pm

%files tests
%{_libexecdir}/%{name}

%changelog
