Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Tk/Dial.pm) perl(Tk/DirSelect.pm) perl(Tk/FileDialog.pm) perl(Tk/NumEntry.pm) perl(Tk/PathEntry.pm) perl(WidgetDemo.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Tk-Getopt
Version:        0.52
Release:        alt1_3
Summary:        User configuration window for Tk with interface to Getopt::Long
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Tk-Getopt
Source0:        https://cpan.metacpan.org/authors/id/S/SR/SREZIC/Tk-Getopt-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(Safe.pm)
BuildRequires:  perl(Tk.pm)
# Optional      perl(Tk::Balloon)
BuildRequires:  perl(Tk/BrowseEntry.pm)
BuildRequires:  perl(Tk/CmdLine.pm)
# Optional fall back  perl(Tk::DirSelect)
BuildRequires:  perl(Tk/DirTree.pm)
# Optional perl(Tk::FileDialog) is old and buggy. Tk::FileSelect is fall-back
BuildRequires:  perl(Tk/FileSelect.pm)
BuildRequires:  perl(Tk/Font.pm)
# Optional not yet packaged perl(Tk::FontDialog)
# Optional      perl(Tk::NoteBook)
BuildRequires:  perl(Tk/Optionmenu.pm)
# Optional not yet packaged perl(Tk::PathEntry)
BuildRequires:  perl(Tk/Photo.pm)
BuildRequires:  perl(Tk/Pixmap.pm)
BuildRequires:  perl(Tk/Tiler.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(vars.pm)
# Optional tests
BuildRequires:  perl(File/Temp.pm)
# Optional not yet packaged perl(Tk::Dial)
Requires:       perl(Cwd.pm)
Requires:       perl(Data/Dumper.pm)
Requires:       perl(File/Basename.pm)
Requires:       perl(File/Spec.pm)
Requires:       perl(Getopt/Long.pm)
Requires:       perl(Safe.pm)
Requires:       perl(Tk.pm) >= 804
# Optional      perl(Tk::Balloon)
Requires:       perl(Tk/BrowseEntry.pm)
Requires:       perl(Tk/CmdLine.pm)
# Optional fall back  perl(Tk::DirSelect)
Requires:       perl(Tk/DirTree.pm)
# Optional perl(Tk::FileDialog) is old and buggy. Tk::FileSelect is fall-back
Requires:       perl(Tk/FileSelect.pm)
Requires:       perl(Tk/Font.pm)
# Optional not yet packaged perl(Tk::FontDialog)
# Optional      perl(Tk::NoteBook)
Requires:       perl(Tk/Optionmenu.pm)
# Optional not yet packaged perl(Tk::PathEntry)
Requires:       perl(Tk/Photo.pm)
Requires:       perl(Tk/Pixmap.pm)
Requires:       perl(Tk/Tiler.pm)

# Filter optional not yet packaged perl(Tk::PathEntry)

Source44: import.info
%filter_from_requires /^perl(Tk.PathEntry.pm)/d

%description
Tk::Getopt provides an interface to access command line options via
Getopt::Long and editing with a graphical user interface via a Tk window.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(File/Temp.pm)
Requires:       perl(File/Spec.pm)
Requires:       perl(Test/More.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Tk-Getopt-%{version}

chmod +x t/*.t

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*
# Install tests
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/%{name}
cp -a t $RPM_BUILD_ROOT%{_libexecdir}/%{name}
cat > $RPM_BUILD_ROOT%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x $RPM_BUILD_ROOT%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes demos README
%dir %{perl_vendor_privlib}/Tk
%{perl_vendor_privlib}/Tk/Getopt.pm

%files tests
%{_libexecdir}/%{name}

%changelog
