# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Tk.pm) perl(Tk/Frame.pm) perl(Tk/MMutil.pm) perl(Tk/widgets.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Tk-NumKeypad
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4
Release: alt4
Summary: Numeric Keypad widget
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROSCIO/%{module_name}-%{version}.tar.gz

%description
A numeric keypad, including a clear button and a decimal point button.
This is useful for touchscreen or kiosk applications where access to a 
keyboard won't be available.

Math keys may be included too; and you may substitute other characters
for the default keys.

The keypad is arranged as follows:

    7 8 9           7 8 9 /
    4 5 6     or    4 5 6 *
    1 2 3           1 2 3 -
    . 0 C           . 0 C +

The widget is designed to supply values to a Tk::Entry or Tk::Text widget.
Specify the Tk::Entry or Tk::Text widget with the -entry option.

The following options/value pairs are supported:

=over 4

=item -entry

Identifies the associated Tk::Entry or Tk::Text widget to be populated or cleared
by this keypad.

=item -keysub

Provide a hashref of substitution strings for the labels on the button keys.
For example, to change the 'C' (clear) key to an 'X':

  -keysub => {'C' => 'X'}

The keys still return their original values, unless you also use -keyval.

=item -keyval

Provide a hashref of alternate values to provide for keys, that's put into your
Tk::Entry or Tk::Text widget.  For example,

  -keyval => {'1' => 'one '}

Note that the special values 'BACKSPACE', 'CLEAR', and 'DELETE'.
'BACKSPACE' will delete one character back from the current cursor position.
'CLEAR' will clear the contents of your text or entry widget.
'DELETE' will delet the character at (after) the current cursor position.

By default, the 'C' key is associated with the 'CLEAR' action.

A popular modification of this KeyPad widget is to change the dot (.) key
into a backspace key, like this:

   -keysub => {'.' => "\x{21d0}"},  # this is the double-line left arrow symbol
   -keyval => {'.' => 'BACKSPACE'},


=item -math

If true, the mathematics keys / (divide), * (multiply), - (subtraction),
and + (addition) are included in the keypad.

=item -text

Alias for -entry.  Use of -text is preferred if the widget really is a Tk::Text.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_archlib/T*
%changelog
