# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl(MooseX/Role/Parameterized.pm) perl(Sub/Install.pm) perl(Sub/NonRole.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.005
%define module_name Trait-Attribute-Derived
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: trait for lazy-built Moose attributes that are derived from another attribute
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Trait-Attribute-Derived

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
It is quite common in the Moose manpage to have one attribute derived from another
via lazy builders. Often you will have several which are very similar:

   has first_name => (
      is           => 'ro',
      lazy         => 1,
      builder      => '_build_first_name',
   );
   
   sub _build_first_name {
      my $self = shift;
      (split /\s/, $self->full_name)[0];
   }
   
   has last_name => (
      is           => 'ro',
      lazy         => 1,
      builder      => '_build_last_name',
   );
   
   sub _build_last_name {
      my $self = shift;
      (split /\s/, $self->full_name)[-1];
   }

Other examples might be an attribute holding an XML DOM tree where several
attributes are lazily built using XPath queries; or an attribute holding a
DBI database handle where several attribues are lazily built by querying
the database; or where one attribute holds the binary contents of a file,
and others are fields extracted using `unpack'.

Trait::Attribute::Derived allows you to automate some of this, reducing
duplicated code.

Trait::Attribute::Derived is a trait for Moose attributes; it a parameterized
role. The first step when using it is to create a variant of the role with
the parameters filled in.

   use Trait::Attribute::Derived Split => {
      fields    => { segment => 'Num' },
      processor => sub { (split)[$_{segment}] },
   };

This defines a variant called `Split'. The `processor' coderef is the
template for deriving a lazily built attribute from a source attribute.
Within this coderef, the special global `$_' is set to the value of
the source attribute, and the special global `%%_' hash contains a
set of other fields useful in deriving the lazily built attributes.

Using our example from the SYNOPSIS, `$_' will be the string
`"Robert Redford"' and `%%_' will be a hash `(segment => 0)'
when building the `first_name' or `(segment => -1)' when building
the `last_name'.

If you'd rather not use magic global variables, the coderef is also passed
as arguments (`@_'): `$self', the source attribu...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE README Changes examples
%perl_vendor_privlib/T*

%changelog
