# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(AutoLoader.pm) perl(Benchmark.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define module_name Tree-SizeBalanced
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.006002
Release: alt4
Summary: Size balanced binary search tree (XS implementation)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CI/CINDY/%{module_name}-%{version}.tar.gz

%description
Quoted from http://wcipeg.com/wiki/Size_Balanced_Tree:

=encoding UTF-8

> A size balanced tree (SBT) is a self-balancing binary search tree (BBST) first published by Chinese student Qifeng Chen in 2007. The tree is rebalanced by examining the sizes of each node's subtrees. Its abbreviation resulted in many nicknames given by Chinese informatics competitors, including "sha bi" tree (Chinese: .'O.N'.o'; pinyin: sh.' b.A shav; literally meaning "dumb cunt tree") and "super BT", which is a homophone to the Chinese term for snot (Chinese: .'O.c'; pinyin: badtaE) suggesting that it is messy to implement. Contrary to what its nicknames suggest, this data structure can be very useful, and is also known to be easy to implement. Since the only extra piece of information that needs to be stored is sizes of the nodes (instead of other "useless" fields such as randomized weights in treaps or colours in red.e'black tress), this makes it very convenient to implement the select-by-rank and get-rank operations (easily transforming it into an order statistic tree). It supports standard binary search tree operations such as insertion, deletion, and searching in O(log n) time. According to Chen's paper, "it works much faster than many other famous BSTs due to the tendency of a perfect BST in practice."

For performance consideration, this module provides trees with many stricter types.

If you choose any scalar as the key type, you must provide a comparing sub.
The comparing sub should exammed localized `$a' and `$b' (or `$::a' and `$::b' if there are introduced lexical <$a> and <$b> right outside the sub).
And if your comparing sub using an indirect way to judge the size of the keys,
don't do anything that will change the judge result. Or, the tree will be confused and give you incorrect results.

If you put more than one entries with equal-sized keys,
the insertion order is preserved by treating the first one as the smallest one among them.

PS. Qifeng Chen is .''.'U.uO in simplified Chinese.

This module has been tested ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
