# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Tree-Trie
%define upstream_version 1.9

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_14

Summary:    A data structure optimized for prefix lookup
License:    GPL
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Tree/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(Pod/Coverage.pm)
BuildRequires: perl(Test/Pod.pm)
BuildRequires: perl(Test/Pod/Coverage.pm)
BuildArch:  noarch
Source44: import.info

%description
This module implements a trie data structure.  The term "trie"
comes from the word retrieval, but is generally pronounced like
"try".  A trie is a tree structure (or directed acyclic graph),
the nodes of which represent letters in a word.  For example, the
final lookup for the word 'bob' would look something like
"$ref->{'b'}{'o'}{'b'}{HASH(0x80c6bbc)}" (the HASH being an end
marker).  Only nodes which would represent words in the trie
exist, making the structure slightly smaller than a hash of the
same data set.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
rm -f t/02_pod_cover.t

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%{perl_vendor_privlib}/Tree


%changelog
