# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Tribology-Lubricant
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Data type that represents a Lubricant class.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SH/SHERZODR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class, given technical data based on lubricant TDS/PDS documents assists in calculation of various Rheologic characteristics of the lubricant. Such as:

=over 4

=item * 

V-T behavior (`m()') using Ubbelohde-Walter equation

=item * 

Calculate viscosity at a given temperature ( `visc()' ) when any of two calibration points are known

=item * 

Calculate viscosity index using ASTM D2270's A and B procedures ( `vi()' )

=item * 

Lookup L and H constants of the lubricant using ASTM D2270 Table and using linear interoplation whenever neccessary ( `LH()' )

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes data.txt
%perl_vendor_privlib/T*

%changelog
