%define module_name Try-Tiny-Tiny
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Pod/Readme/Brief.pm) perl(Software/LicenseUtils.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: slim Try::Tiny down as far as reasonably possible
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARISTOTLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The reason this module exists is that the Try::Tiny manpage will try naming the blocks
it is passed, if it can load a module for doing so. This takes meaningful time,
is only useful in stack traces, and then may defeat code that tries to examine
the stack to print a more helpful error message.

Now, you yourself can avoid using the Try::Tiny manpage in the first place, but you will
almost inevitably still pull it in through your dependency chain, and it is not
likely to be feasible to scrub it out.

This module helps sanitise your dependency chain a bit without patching all of
it by loading the Try::Tiny manpage in such a way that it is forced to skip naming its
callbacks. In order to be useful, you must use this module before using any
other module that loads the Try::Tiny manpage. In practice that means you probably want
to load it as early as possible, such as through PERL5OPT.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
