Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Class/Throwable.pm) perl(Exception/Class.pm) perl(Exception/Class/TryCatch.pm) perl(File/Copy/Recursive.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Class.pm) perl(XML/SAX/Base.pm) perl(XML/SAX/Expat.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run optional tests
%{bcond_without perl_TryCatch_enables_optional_test}

Name:           perl-TryCatch
Version:        1.003002
Release:        alt13_40
Summary:        First class try catch semantics for Perl, without source filters
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/TryCatch
Source0:        https://cpan.metacpan.org/authors/id/A/AS/ASH/TryCatch-%{version}.tar.gz
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
# perl-podlators (pod2text) not used
BuildRequires:  perl(ExtUtils/Depends.pm)
# File::Copy::Recursive not used
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Can.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
# Path::Class not used
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(B/Hooks/EndOfScope.pm)
BuildRequires:  perl(B/Hooks/OP/PPAddr.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Devel/Declare.pm)
BuildRequires:  perl(Devel/Declare/Context/Simple.pm)
BuildRequires:  perl(Devel/PartialDump.pm)
BuildRequires:  perl(Moose/Util/TypeConstraints.pm)
BuildRequires:  perl(namespace/clean.pm)
BuildRequires:  perl(Parse/Method/Signatures.pm)
BuildRequires:  perl(Scope/Upper.pm)
BuildRequires:  perl(Sub/Exporter.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests:
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_TryCatch_enables_optional_test}
# Optional tests:
BuildRequires:  perl(MooseX/Types/Structured.pm)
# XML::SAX::Base useless without XML::SAX::Expat
# XML::SAX::Expat not yet packaged
%endif
Requires:       perl(B/Hooks/EndOfScope.pm) >= 0.120
Requires:       perl(B/Hooks/OP/PPAddr.pm) >= 0.030
Requires:       perl(Devel/Declare.pm) >= 0.005.007
Requires:       perl(namespace/clean.pm) >= 0.200
Requires:       perl(Parse/Method/Signatures.pm) >= 1.003.012
Requires:       perl(Scope/Upper.pm) >= 0.060
Requires:       perl(Sub/Exporter.pm) >= 0.979



# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(B.Hooks.EndOfScope\|B.Hooks.OP.PPAddr\|Devel.Declare\|namespace.clean\|Parse.Method.Signatures\|Scope.Upper\|Sub.Exporter\).pm)/d

%description
This module aims to provide a nicer syntax and method to catch errors in
Perl, similar to what is found in other languages (such as Java, Python or
C++). The standard method of using eval {}; if ($@) {} is often prone to
subtle bugs, primarily that its far too easy to stomp on the error in error
handlers. And also eval/if isn't the nicest idiom.

%prep
%setup -q -n TryCatch-%{version}
# Remove bundled modules
rm -r ./inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README eg
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/TryCatch*

%changelog
