%define module_name Twitter-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(HTML/Entities.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(HTTP/Thin.pm) perl(IO/Socket/SSL.pm) perl(JSON/MaybeXS.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(MooX/Aliases.pm) perl(MooX/Traits.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(StackTrace/Auto.pm) perl(Sub/Exporter/Progressive.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Spec.pm) perl(Test/Warnings.pm) perl(Throwable.pm) perl(Time/HiRes.pm) perl(Time/Local.pm) perl(Try/Tiny.pm) perl(URI.pm) perl(URL/Encode.pm) perl(WWW/OAuth.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0006
Release: alt1
Summary: A Twitter REST API library for Perl
Group: Development/Perl
License: perl
URL: https://github.com/semifor/Twitter-API

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MM/MMIMS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Twitter::API provides an interface to the Twitter REST API for perl.

This in an alpha release. The interface may change. Feedback welcome.

Features:

=over 4

=item *

full support for all Twitter REST API endpoints

=item *

not dependent on a new distribution for new endpoint support

=item *

optionally specify access tokens per API call

=item *

error handling via an exception object that captures the full reqest/response context

=item *

full support for OAuth handshake and xauth authentication

=back

Additionl features are availble via optional traits:

=over 4

=item *

convenient methods for API endpoints with simplified argument handling via ApiMethods

=item *

normalized booleans (Twitter likes 'true' and 'false', except when it doesn't) via NormalizeBooleans

=item *

automatic decoding of HTML entities via DecodeHtmlEntities

=item *

automatic retry on transient errors via RetryOnError

=item *

"the whole enchilada" combines all the above traits via Enchilada

=item *

app-only (OAuth2) support via AppAuth

=back

Some featuers are provided by separate distributions to avoid additional
dependencies most users won't want or need:

=over 4

=item *

async support via subclass the Twitter::API::AnyEvent manpage

=item *

inflate API call results to objects via the Twitter::API::Trait::InflateObjects manpage

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE examples
%perl_vendor_privlib/T*

%changelog
