%define module_name Types-Mojo
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/BOM.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spec.pm) perl(Type/Library.pm) perl(Type/Utils.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Types related to Mojo
Group: Development/Perl
License: artistic_2
URL: https://github.com/reneeb/Types-Mojo

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLSRVDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
package MyClass;
    
    use Moo;
    use Types::Mojo qw(MojoFile MojoCollection);
    
    has file => ( is => 'rw', isa => MojoFile, coerce => 1 );
    has coll => ( is => 'rw', isa => MojoCollection, coerce => 1 );
    has ints => ( is => 'rw', isa => MojoCollection[Int] );
    
    1;

In the script

    use MyClass;
    my $object = MyClass->new( file => __FILE__ ); # will be coerced into a Mojo::File object
    say $object->file->move_to( '/path/to/new/location' );

    my $object2 = MyClass->new( coll => [qw/a b/] );
    $object2->coll->each(sub {
        say $_;
    });

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README CONTRIBUTORS LICENSE
%perl_vendor_privlib/T*

%changelog
