%define module_name URI-Encode-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt5
Summary: a Perl URI encoder/decoder using C
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DF/DFARRELL/%{module_name}-%{version}.tar.gz

%description
This is a Perl URI encoder/decoder written in XS based on RFC3986.
This module always encodes characters that are not unreserved. When decoding,
invalid escape sequences are preserved, e.g:

  uri_decode("foo%%20bar%%a/"); # foo bar%%a/
  uri_decode("foo%%20bar%%a");  # foo bar%%a
  uri_decode("foo%%20bar%%");   # foo bar%%

As of version 0.09, the `bench' script shows it to be significantly faster
than `URI::Escape':

              Rate escape encode
  escape  144165/s     --   -98%%
  encode 8239785/s  5616%%     --
                Rate unescape   decode
  unescape  196870/s       --     -97%%
  decode   6051468/s    2974%%       --

However this is just one string - the fewer encoded/decoded characters are
in the string, the closer the benchmark is likely to be (see `bench' for
details of the benchmark). Different hardware will yield different results.

Another fast encoder/decoder which supports custom escape lists, is
URI::XSEscape.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod LICENSE
%perl_vendor_archlib/U*
%perl_vendor_autolib/*

%changelog
