%define module_version 0.002
%define module_name URI-Normalize
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(URI.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Normalize URI paths
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HA/HANENKAMP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Section 6 of RFC 3986 describes a process of URI normalization. This implements
syntax-based normalization and may include some schema-based and protocol-based
normalization. This includes implementing the `remove_dot_segments' algorithm
described in Section 5.2.3 of the RFC.

This has a number of useful applications in allowing URIs to be compared with
fewer false negatives. For example, all of the following URIs will normalize to
the same value:

    HTTPS://www.example.com:443/../test/../foo/index.html
    https://WWW.EXAMPLE.COM/./foo/index.html
    https://www.example.com/%%66%%6f%%6f/index.html
    https://www.example.com/foo/index.html

That is, they will all be normalized into the last value.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/U*

%changelog
