%define module_name URI-tel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(URI.pm) perl(overload.pm) perl(overloading.pm) perl(parent.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.801.1
Release: alt1
Summary: The tel URI for Telephone Numbers (RFC 3966)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
The termination point of the "tel" URI telephone number is not
restricted.  It can be in the public telephone network, a private
telephone network, or the Internet.  It can be fixed or wireless and
address a fixed wired, mobile, or nomadic terminal.  The terminal
addressed can support any electronic communication service (ECS),
including voice, data, and fax.  The URI can refer to resources
identified by a telephone number, including but not limited to
originators or targets of a telephone call.

The "tel" URI is a globally unique identifier ("name") only; it does
not describe the steps necessary to reach a particular number and
does not imply dialling semantics.  Furthermore, it does not refer to
a specific physical device, only to a telephone number.

Changes Since RFC 2806

The specification is syntactically backwards-compatible with the
"tel" URI defined in RFC 2806 [RFC2806] but has been completely
rewritten.  This document more clearly distinguishes telephone
numbers as identifiers of network termination points from dial
strings and removes the latter from the purview of "tel" URIs.

Compared to RFC 2806, references to carrier selection, dial context,
fax and modem URIs, post-dial strings, and pause characters have been
removed.  The URI syntax now conforms to RFC 2396 [RFC2396].


%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/U*

%changelog
