%define module_name USB-LibUSB
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(AutoLoader.pm) perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Load.pm) perl(Moo.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(strict.pm) perl(warnings.pm) pkgconfig(libusb) pkgconfig(libusb-1.0)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt4
Summary: Perl interface to the libusb-1.0 API.
Group: Development/Perl
License: perl
URL: http://www.labmeasurement.de

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AM/AMBA/%{module_name}-%{version}.tar.gz

%description
This module provides a Perl interface to the libusb-1.0 API.
It provides access to most basic libusb functionality including read-out of
device descriptors and synchronous device I/O. 

The design of the module is basically a two-tier system:

=over

=item the USB::LibUSB::XS manpage

Raw XS interface, stay as close at possible to the libusb API. Not intended to
be used directly.

=item USB::LibUSB

Based on USB::LibUSB::XS, adds convenient error handling and additional
high-level functionality (e.g. device discovery with vid, pid and serial
number). Easy to build more functionality without knowing about XS.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO Changes README
%perl_vendor_archlib/U*
%perl_vendor_autolib/*

%changelog
