%define _without_test 1
%define module_version 1.02
%define module_name Unicode-Semantics
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Work around *the* Perl 5 Unicode bug
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JU/JUERD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Although the internal encoding of a string is hidden from the Perl programmer,
it does unfortunately affect semantics. Perl uses Unicode semantics when the
internal encoding for a string is UTF8, but it uses *ASCII* semantics when the
internal encoding is ISO-8859-1.

Because you shouldn't (and often don't) know what the internal encoding will
be, it's hard to predict whether these operations will actually do what you
want. Unicode::Semantics::us() gives you predictable results for your string.

Normally, the non-ASCII part of the character set is ignored when for the
following operations on a string of which the internal encoding is ISO-8859-1:

    * uc, lc, ucfirst, lcfirst, \U, \L, \u, \l
    * \d, \s, \w, \D, \S, \W
    * /.../i, (?i:...)
    * /[[:posix:]]/

This module exports `us' that upgrades your string to UTF-8 internally and
returns the string. An alias, `up', is also exported by default. After
initially releasing the module with `us', I changed my mind and starting
liking `up' better.

You can also use the built-in function `utf8::upgrade', which upgrades the
string and returns the number of octets used for the internal UTF8 buffer.

Non-string values (like numbers, references, objects, and undef) are
stringified on upgrade.

`us', `up', and `utf8::upgrade' mutate the variable's actual value. If you
need to upgrade only a copy of a string, make the copy first:

    up(my $copy = $original);

Upgrading an already upgraded variable does not re-upgrade, so it is safe.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/U*

%changelog
