%define module_name VM-Libvirt-CloneHelper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(JSON.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Create a bunch of cloned VMs in via libvirt.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# initialize it
    my $clone_helper=VM::Libvirt::CloneHelper->new({
        blank_domains=>'/usr/local/etc/clonehelper/blank_domains',
        net_head=>'/usr/local/etc/clonehelper/net_head',
        net_tail=>'/usr/local/etc/clonehelper/net_tail',
        windows_blank=>0,
        mac_base=>'00:08:74:2d:dd:',
        ipv4_base=>'192.168.1.',
        start=>'100',
        to_clone=>'baseVM',
        clone_name_base=>'foo',
        count=>10,
        verbose=>1,
        snapshot_name=>'clean',
        net=>'default',
    });

    $clone_helper->delete_vms;
    $clone_helper->clone_vms;
    $clone_helper->start_vms;
    sleep 500;
    $clone_helper->snapshot_vms;
    $clone_helper->shutdown_vms;

It should be noted that this is effectively limited to 253 VMs.

This script lib is primarily meant for creating a bunch of cloned VMs on a
box for testing purposes, so this is not really a major issue given the
design scope.

VMs should be set to us DHCP so they will get their expected IP when they boot.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/V*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
