Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-VMware-LabManager
Version:        0.01
Release:        alt2_39
Summary:        Perl module to provide basic VMware Lab Manager operations
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/VMware-LabManager
Source0:        https://cpan.metacpan.org/authors/id/A/AI/AIVATURI/VMware-LabManager-%{version}.tar.gz
Patch0:         VMware-LabManager-0.01-Fix-building-on-Perl-without-dot-in-INC.patch
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# inc
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(CPAN.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MM_Unix.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(FindBin.pm)
# Runtime, SOAP::Lite is needed for the debug mode
BuildRequires:  perl(SOAP/Lite.pm)
BuildRequires:  perl(Time/HiRes.pm)
# Tests only
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Test/CheckManifest.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
# In evals, not autodetected
Requires:       perl(SOAP/Lite.pm)
Source44: import.info

%description
This module does not provide a one-to-one mapping of the Lab Manager SOAP
API, but rather it provides an API wrapper, which combines certain SOAP
calls as a meaningful single operation. Thus this module is heavily
tailored for automation purposes. But, it should also cater to the
broader audience as it still does provide overall functionality that
might be required.

%prep
%setup -q -n VMware-LabManager-%{version}
%patch0  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install PERL_INSTALL_ROOT=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
