%define module_name Validate-CodiceFiscale
# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON/PP.pm) perl(Module/Build/Tiny.pm) perl(Path/Tiny.pm) perl(Test/Exception.pm) perl(Test/Pod.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: Validate an Italian "Codice Fiscale"
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POLETTIX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module performs partial validation of Italian Codice Fiscale,
mainly at the syntactic level. For proper and legally acknowledged
validation please refer to the official service by Agenzia delle Entrate
at https://telematici.agenziaentrate.gov.it/VerificaCF/Scegli.do?parameter=verificaCf.

At the basic level, it allows spotting common errors that might come
from copying/typing the Codice Fiscale, e.g. typing a 0 (zero) instead
of an uppercase o letter, or similar errors with other digits/letters.

The validation can optionally take additional data regarding the name,
surname, birth date, birth place, and sex to perform a more thorough
validation based on the official rules. This part is subject to false
positives for the following reasons:

=over

=item *

Places are required to be entered as official codes, but there is no
validation that the specific code was active at the date of birth in the
Codice Fiscale. As an example, the `$valid' Codice Fiscale in the
the SYNOPSIS entry elsewhere in this document is syntactally valid, but otherwise impossible because code
`B833' disappeared in 1995 (two places were merged together).

=item *

The algorithm to generate the CodiceFiscale might lead to the same
string for different people. This is accounted for by using a
substitution of digits with letters, but only Agenzia delle Entrate can
tell whether the specific person holds the specific variant of the code.

=back

So well... use it to spot negatives, but don't trust positives too much.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/V*

%changelog
