%define module_name Vcdiff
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Symbol.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.505
Release: alt2
Summary: diff and patch for binary data
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Given source and target data, the `Vcdiff::diff' function computes a "delta" that encodes the difference information needed to turn source into target. Anyone who has source and delta can derive target with the `Vcdiff::patch' function.

The point of this module is that if the source and target inputs are related then delta can be small relative to target, meaning it may be more efficient to send delta updates to clients over the network instead of re-sending the whole target every time.

Even though source and target don't necessarily have to be binary data (regular data is fine too), the delta will contain binary data including NUL bytes so if your transport protocols don't support this you will have to encode or escape the delta in some way (ie base64). Compressing the delta before you do this might be worthwhile depending on the size of your changes and the entropy of your data.

The delta format is described by RFC 3284, "The VCDIFF Generic Differencing and Compression Data Format".

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/V*

%changelog
