%define module_name Video-ZVBI
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(DynaLoader.pm) perl(Exporter.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators
BuildRequires: libzvbi-devel

Name: perl-%module_name
Version: 1.1.1
Release: alt2
Summary: Interface to the Zapping VBI decoder library
Group: Development/Perl
License: GPL
URL: https://github.com/tomzox/Perl-Video-ZVBI

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOMZO/%{module_name}-%{version}.tar.gz

%description
This module provides a Perl interface to libzvbi.  The ZVBI library
allows to access broadcast data services such as teletext or
closed caption via analog video or DVB capture devices.

Official library description:
"The ZVBI library provides routines to access raw VBI sampling devices
(currently the Linux V4L & V4L2 APIs and the FreeBSD, OpenBSD,
NetBSD and BSDi bktr driver API are supported), a versatile raw VBI
bit slicer, decoders for various data services and basic search, render
and export functions for text pages. The library was written for the
Zapping TV viewer and Zapzilla Teletext browser."

The ZVBI Perl module covers all exported libzvbi functions.  Most of
the functions and parameters are exposed nearly identical, or with
minor adaptions for the Perl idiom.

Note: This manual page does not reproduce the full documentation
which is available along with libzvbi. Hence it's recommended that
you use the libzvbi documentation in parallel to this one. It is
included in the libzvbi-dev package in the `doc/html' sub-directory
and online at http://zapping.sourceforge.net/doc/libzvbi/index.html

Finally note there's also another, older, module which covers VBI
data capture: Video::Capture::VBI and based on that another one which
covers Teletext caching: Video::TeletextDB. Check for yourself which
one fits your needs better.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changelog COPYING README examples
%perl_vendor_archlib/V*
%perl_vendor_autolib/*

%changelog
