# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Math/BigInt.pm)
# END SourceDeps(oneline)
%define module_name Vigil-Token
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.0.0
Release: alt1
Summary: Cryptographically secure, URL-safe token generator for OTPs, sessions, and custom codes.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMELANSON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Vigil::Token is a sleek, high-octane token generator that effortlessly handles both human-friendly codes and 
machine-to-machine secrets. Need a short, 6-digit OTP that users can type without mistaking a 0 for an O? 
Done. Looking for a massive, 256-character session token to lock down API calls or web sessions? Done. 
Every token is backed by cryptographically strong randomness using Bytes::Random::Secure, ensuring each 
byte of entropy is truly unpredictable. All strings are automatically URL-safe via Base64URL encoding, 
so they slide seamlessly into cookies, query strings, or HTML forms without worrying about escaping. With 
its flexible custom_token() function, Vigil::Token balances readability and security perfectly: short codes 
are human-friendly, long codes maximize entropy, and all tokens are guaranteed to be the exact length you 
request. Lightweight, reliable, and unrelentingly secure, Vigil::Token is the ultimate Swiss Army knife for 
modern web authentication and cryptographic token needs.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE.txt CHANGES.txt
%perl_vendor_privlib/V*

%changelog
