Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Fatal.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#
# Rebuild option:
#
#   --with testsuite         - run the test suite (requires network)
#

Name:           perl-WWW-Bugzilla
Version:        1.5
Release:        alt3_40
Summary:        Handles submission/update of bugzilla bugs via WWW::Mechanize

# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/WWW-Bugzilla
Source0:        https://cpan.metacpan.org/authors/id/B/BM/BMC/WWW-Bugzilla-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Class/MethodMaker.pm)
BuildRequires:  perl(WWW/Mechanize.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Crypt/SSLeay.pm)
BuildRequires:  perl(Params/Validate.pm)
Requires:       perl(Class/MethodMaker.pm) >= 1.080


Source44: import.info

%description
This module provides a perl API for adding and updating Bugzilla bugs.
It can be useful in writing custom frontends to a Bugzilla server, and
the frontends do not have to sit on the same server as long as they
can reach it via HTTP.


%prep
%setup -q -n WWW-Bugzilla-%{version}
mkdir lib
cp -r WWW lib


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
chmod -R u+w $RPM_BUILD_ROOT/*


%check
%{?_with_testsuite:make test}


%files
%doc Changes README
%doc --no-dereference ARTISTIC GPL
%{perl_vendor_privlib}/WWW/


%changelog
