# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Class/Accessor/Children/Fast.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Iterator/Simple.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(XML/Simple.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.1.0
%define module_name WWW-FreshBooks-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Perl Interface to the Freshbooks 2.1 API!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MINDHACK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The long awaited update to the original perl freshbooks api interface adds some much needed data handling
improvements, on-the-fly response item class creation, and a simple result item iterator for improved 
handling of result lists.  Stubs of the original implementation exist for backwards compatibility, and 
access to new features are possible without changing old code.

The result item classes are built on the fly using the data contained within the response.  This is meant
to keep class accessors up to date in the absence of a provided service description and without having to
maintain your own.  Example of how this works:

	# your "client.list" request returns:
	 <?xml version="1.0" encoding="utf-8"?>  
	 <response status="ok">  
	   <clients page="1" per_page="15" pages="3" total="42">  
	     <client>  
	       <client_id>13</client_id>  
	       <organization>ABC Corp</organization>  
	       <username>janedoe</username>  
	       <first_name>Jane</first_name>  
	       <last_name>Doe</last_name>  
	       <email>janedoe@freshbooks.com</email>  
	     </client>  
	     ...  
	   </clients>  
	 </response>

	# on the fly we create WWW::FreshBooks::API::Client with accessors available via:
	my $item = $results->iterator->next();
	$item->client_id;		# 13
	$item->organization; 	# ABC Corp
	$item->username;		# janedoe
	....


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/W*

%changelog
