# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.13
%define module_name WWW-HarWalk
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Replay HTTP requests from HAR ( HTTP Archive ) file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/X/XU/XUDAYE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use LWP::UserAgent;
    use WWW::HarWalk qw(walk_har);
    
    my $ua = LWP::UserAgent->new;

    # simple usage
    walk_har($ua, 'c.lietou.com.har');
    
    # with hooks
    walk_har($ua,                 # a LWP::UserAgent instance
         'c.lietou.com.har',      # har file path
         sub {
             my $entry = shift;   # entries item in har
             
             # request of the entry item. Note: this is not the HTTP::Request instance
             my $request = $entry->{request};
             
             # return false to skip this entry
             return 0 if $request->{url} =~ /\.(?:gif|png|css|js)(?:\?.*)?$/;
             
             # modify post params
             if ($request->{url} =~ /login.php/) {
                 $request->{postData}->{text} =~ s/username=\w+/username=Tom/;
             }
             
             # must return true to request this entry
             return 1;
         },
         sub {
             # $res is a HTTP::Response intance, decoded
             my ($entry, $res, $entries) = @_;
             
             # you can print or capture something from some response
             if ($entry->{request}->{url} =~ /refreshresume/) {
                 print $res->content, "\n";
             }
         });


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/W*

%changelog
