# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(Test/More.pm) perl(WWW/JSONAPI.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name WWW-KeePassRest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: use KeePass for secure local secret storage
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MICHAEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
KeePass is a nifty Windows app (with work-alikes for Linux) that stores passwords and other sensitive
information in an encrypted database on the local hard drive. When open, it can then be used to manage
usernames and passwords, even generating new passwords with crunchy random goodness.

Wouldn't it be nice if you could just use the open KeePass instance for unattended retrieval of usernames
and passwords for your Web-enabled scripts? Well, with the doubly nifty KeePassRest plug-in, you can do
just that!

The KeePassRest plug-in is available at the SmartFTP website: https://www.smartftp.com/keepassrest

KeePassRest exposes a minimal API on localhost:12984, secured by SSL and accessed with a JSON API.
You can't do everything with it (you can't generate passwords, work with groups of entries, etc.) but
for that stuff you've got the File::KeePass manpage anyway.

Here's the absolutely simplest possible way to use WWW::KeePassRest:

    use LWP;
    use WWW::KeePassRest;
    use strict;

    my $url = 'http://somesite.com/aa/bb/cc.html';
    my $browser = LWP::UserAgent->new('Mozilla');
    $browser->credentials("somesite.com:80", "Realm", WWW:::KeePassRest->get_by_title('Some site credentials', 'UserName', 'Password'));
    my $response=$browser->get($url);

Seriously. Easy as that. Notice that there is *absolutely no sensitive information* in this script.
The username and password are stored in KeePass under the title "Some site credentials". The script will
only run when KeePass is running and you've given it your password entirely separately - and that needs
to happen *once*, after which your scripts can run to your heart's content with no further need to
enter passwords.
If KeePass is not running, the call here will croak with "500 Can't connect", so you can easily trap for that case.

Note that KeePass is actually based on a nifty key/value-oriented database and could be used for any kind
of sensitive information, not just usernames and passwords.

Please note: The first time you use this module to hit the KeePass database, you'll see a security popup.
It provides the thumbprint from the certificate bundled with this distribution. Once you accept it, KeePassRest
saves it to an entry in the KeePass database, and if you subsequently save the database you'll never see
the popup again. However, if you let KeePass shut down due to your laptop hibernating or the like, then it
won't save the database, and you'll see that popup again. So word to the wise: save the database after using
this module the first time.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/W*
%perl_vendor_privlib/auto/*

%changelog
