%define module_name WWW-Mechanize-Chrome-DOMops
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Roundtrip.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Log/Log4perl.pm) perl(String/Escape.pm) perl(Test/More.pm) perl(Test/TempDir/Tiny.pm) perl(Test2/Plugin/UTF8.pm) perl(WWW/Mechanize/Chrome.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Operations on the DOM loaded in Chrome
Group: Development/Perl
License: artistic_2
URL: https://metacpan.org/module/WWW::Mechanize::Chrome::DOMops

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLIAKO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a set of tools to operate on the DOM of the
provided the WWW::Mechanize::Chrome manpage object. Currently,
supported operations are:

=over 4

=item * `find()' : finds HTML elements

=item * `zap()' : deletes HTML elements

=back

The selection of the HTML elements in the DOM
can be done in various ways:

=over 4

=item * by CSS selector,

=item * by tag,

=item * by class.

=item * by id,

=item * by name.

=back

There is more information about this in section the ELEMENT SELECTORS entry elsewhere in this document.

Here are some usage scenaria:

    use WWW::Mechanize::Chrome::DOMops qw/zap find VERBOSE_DOMops/;

    # increase verbosity: 0, 1, 2, 3
    $WWW::Mechanize::Chrome::VERBOSE_DOMops = 3;

    # First, create a mech object and load a URL on it
    # Note: you need google-chrome binary installed in your system!
    my $mechobj = WWW::Mechanize::Chrome->new();
    $mechobj->get('https://www.bbbbbbbbb.com');

    # find elements in the DOM, select by id, tag, name, or 
    # by CSS selector.
    my $ret = find({
       'mech-obj' => $mechobj,
       # find elements whose class is in the provided
       # scalar class name or array of class names
       'element-class' => ['slanted-paragraph', 'class2', 'class3'],
       # *OR* their tag is this:
       'element-tag' => 'p',
       # *OR* their name is this:
       'element-name' => ['aname', 'name2'],
       # *OR* their id is this:
       'element-id' => ['id1', 'id2'],
       # just provide a CSS selector and get done with it already
       'element-cssselector' => 'a-css-selector',
       # specifies that we should use the union of the above sets
       # hence the *OR* in above comment
       '||' => 1,
       # this says to find all elements whose class
       # is such-and-such AND element tag is such-and-such
       # '&&' => 1 means to calculate the INTERSECTION of all
       # individual matches.
       
       # optionally run javascript code on all those elements matched
       'find-cb-on-matched' => [
         {
...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes
%perl_vendor_privlib/W*

%changelog
