# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Net/OAuth.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(WWW/Mechanize.pm)
# END SourceDeps(oneline)
%define module_version 0.12
%define module_name WWW-Netflix-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Interface for Netflix's API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STEVED/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use WWW::Netflix::API;
  use XML::Simple;
  use Data::Dumper;

  my %%auth = Your::Custom::getAuthFromCache();
  # consumer key/secret values below are fake
  my $netflix = WWW::Netflix::API->new({
        consumer_key    => '4958gj86hj6g99',
        consumer_secret => 'QWEas1zxcv',
	access_token    => $auth{access_token},
	access_secret   => $auth{access_secret},
	user_id         => $auth{user_id},

	content_filter => sub { use XML::Simple; XMLin(@_) },  # optional
  });
  if( ! $auth{user_id} ){
    my ( $user, $pass ) = .... ;
    @auth{qw/access_token access_secret user_id/} = $netflix->RequestAccess( $user, $pass );
    Your::Custom::storeAuthInCache( %%auth );
  }

  $netflix->REST->Users->Feeds;
  $netflix->Get() or die $netflix->content_error;
  print Dumper $netflix->content;

  $netflix->REST->Catalog->Titles->Movies('18704531');
  $netflix->Get() or die $netflix->content_error;
  print Dumper $netflix->content;

And for resources that do not require a netflix account:

  use WWW::Netflix::API;
  use XML::Simple;
  my $netflix = WWW::Netflix::API->new({
        consumer_key
        consumer_secret
        content_filter => sub { XMLin(@_) },
  });
  $netflix->REST->Catalog->Titles;
  $netflix->Get( term => 'zzyzx' );
  printf "%%d Results.\n", $netflix->content->{number_of_results};
  printf "Title: %%s\n", $_->{title}->{regular} for values %%{ $netflix->content->{catalog_title} };


  # Retrieve entire catalog:
  $netflix->content_filter('catalog.xml');
  $netflix->REST->Catalog->Titles->Index;
  $netflix->Get();


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes TODO examples
%perl_vendor_privlib/W*

%changelog
