# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/WebSocket/Client.pm) perl(Carp.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(Moo.pm) perl(Test/Fatal.pm) perl(Test/Spec.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%def_without test
%define module_name WWW-Pusher-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Laughably incomplete Perl client for Pusher WS API
Group: Development/Perl
License: perl
URL: https://github.com/honeydew-sc/WWW-Pusher-Client

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GEMPESAW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Pusher is a hosted API for the websocket protocol. WWW::Pusher::Client
is a laughably incomplete Perl client for their interface. It's really
only suited for joining one channel in its lifetime - `trigger' uses
only the most recent channel as defaults.

    use WWW::Pusher::Client;
    my $pusher =  WWW::Pusher::Client->new(
        auth_key => $ENV{AUTH_KEY},
        secret => $ENV{SECRET},
        channel => 'private-channel'
    );

    use JSON;
    $pusher->trigger('my_event', 'this is some data that isn\'t JSON');
    $pusher->trigger('my_event', to_json({
        json => 'json also works!'
    });

The main difference between this module and the WWW::Pusher manpage is that
this module enables you to subscribe to channels like the WebSocket
Pusher clients allow you to do. the WWW::Pusher manpage interacts with Pusher
via its HTTP API, which doesn't allow for subscriptions. On the other
hand, this module uses the AnyEvent::WebSocket::Client entry elsewhere in this document to join
channels via websockets and receive real time messages in addition to
triggering them.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/W*

%changelog
