%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(Digest/MD5.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Cookies.pm) perl(HTTP/Headers.pm) perl(HTTP/Request/Common.pm) perl(IO/Compress/Zip.pm) perl(LWP/UserAgent.pm) perl(Net/SMTP/TLS.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name WWW-Salesforce-Report
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: The poor man's Salesforce report API in Perl!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PA/PAIXAOP/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Create a rough API for Salesforce.com reports. Reports are downloaded in CSV.format from Salesforce and can then be cached locally in a SQLite database.
Regular SQL queries can then be ran on the data.

The reports can also be downloaded in Excel format, which will not be
cache in a local database but can be sent as an attachment to users for example.

Perhaps a little code snippet.

    use WWW::Salesforce::Report;

    my $sfr = WWW::Salesforce::Report->new(
                    id=> "000000068AxXd",
                    user=> "myuser",
                    password => "mypassword" );
        
    $sfr->login();
    $sfr->get_report();
    
    my @data = $sfr->query( query => "select * from report" );

Save a report to an Excel file

    use WWW::Salesforce::Report;

    $sfr = WWW::Salesforce::Report->new(
        id=> "000000068AxXd",
        user=> "myuser",
        password => "mypassword" );
        
    $sfr->login();
    my $xls_data = $sfr->get_report(format => "xls");
    my $name = $sfr->write(file=> "report.xls", compress => 0);

Attach a compressed version of the Excel report to an email and send it to a
user or group of users:

    use WWW::Salesforce::Report;
    use Net::SMTP::TLS;
    use Mime::Lite;
    
    $sfr = WWW::Salesforce::Report->new(
        id=> "000000068AxXd",
        user=> "myuser",
        password => "mypassword" );
        
    $sfr->login();
    my $xls_data = $sfr->get_report(format => "xls");
    my $name = $sfr->write(file=> "report.xls");
    
    # using TLS to send the e-mail
    my $mailer = new Net::SMTP::TLS(
        "mail.domain.com",
        Hello   => "mail.domain.com",
        Port    =>  25,
        User    => "my_user_name",
        Password=> "my_password");
    
    # email of the sender
    $mailer->mail("reports@domain.com");
    
    # email of the recipient
    $mailer->to("user@domain.com");
    
    $mailer->data;
    
    my $message = MIME::Lite->new(
            From    => "reports@domain.com",
            To      => "user@domain.com",
            Subject => "REPORT: Quarter Forecast by Region",
            Type    =>'multipart/mixed'
    );
    
    # Message body
    $message->attach(
            Type => "TEXT",
            Data => "Here are the latest forecast numbers.",
    );
    
    # Attach the zip file
    $message->attach(
            Type => "application/zip",
            Filename => $name,
            Path => $name,
            Encoding => "base64",
            Disposition => 'attachment',
    );  
    
    $mailer->datasend($message->as_string);
    
    $mailer->dataend;
    $mailer->quit;


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/W*

%changelog
